/****************************************************************************

    DIALOGS1.CPP       Version 2.00 / January 1996


    Module containing the dialogs used within the application:

    CAboutDlg
    CBufferDlg
    CWordDlg
    
****************************************************************************/



// Include files
#include "stdafx.h"       // Pre-compiled header

#include "resource.h"
#include "dialogs.h"      // Dialog class definitions

#include "splchk1.h"      // SpellChecker API



/*******************************************************************************

    METHOD:      CAboutDlg()

    PURPOSE:     Methods for the 'About' dialog

*******************************************************************************/

CAboutDlg::CAboutDlg(UINT ipIDD, CWnd* ptpParent)
                     : CDialog(ipIDD, ptpParent){

    //{{AFX_DATA_INIT(CAboutDlg)
    //}}AFX_DATA_INIT
}



void CAboutDlg::DoDataExchange(CDataExchange* pDX) {

    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CAboutDlg)
    //}}AFX_DATA_MAP
}



BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
    //{{AFX_MSG_MAP(CAboutDlg)
        // NOTE: the ClassWizard will add message map macros here
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()










/*******************************************************************************

    METHOD:      CBufferDlg()

    PURPOSE:     Methods for the 'Spell Check buffer' dialog

*******************************************************************************/

CBufferDlg::CBufferDlg(CWnd* ptpParent)
                       : CDialog(CBufferDlg::IDD, ptpParent){

    //{{AFX_DATA_INIT(CBufferDlg)
    tmBuffer = "";
    //}}AFX_DATA_INIT
}



void CBufferDlg::DoDataExchange(CDataExchange* pDX) {

    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CBufferDlg)
    DDX_Text(pDX, EF_SPELLBUFFER, tmBuffer);
    DDV_MaxChars(pDX, tmBuffer, 1024);
    //}}AFX_DATA_MAP
}



BEGIN_MESSAGE_MAP(CBufferDlg, CDialog)
    //{{AFX_MSG_MAP(CBufferDlg)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()



void CBufferDlg::OnOK() {

    int  ilRc;
    char szlString[1025];


    UpdateData(TRUE);

    lstrcpy((LPSTR)szlString, (LPCSTR)tmBuffer);

    ilRc = SpellLoadDictionary();
    if(!ilRc) ilRc = SpellCheckBuffer(this->GetSafeHwnd(),
                                      (LPSTR)szlString, 1024);

    tmBuffer = szlString;

    UpdateData(FALSE);

    SpellCheckError(this->GetSafeHwnd(), ilRc);

    SpellUnloadDictionary();
}










/*******************************************************************************

    METHOD:      CWordDlg()

    PURPOSE:     Methods for the 'Spell Check word' dialog

*******************************************************************************/

CWordDlg::CWordDlg(CWnd* pParent)
                   : CDialog(CWordDlg::IDD, pParent) {

    //{{AFX_DATA_INIT(CWordDlg)
    tmCheckWord = "";
    tmNewWord = "";
    //}}AFX_DATA_INIT
}



void CWordDlg::DoDataExchange(CDataExchange* pDX) {

    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CWordDlg)
    DDX_Text(pDX, EF_CHECKWORD, tmCheckWord);
    DDV_MaxChars(pDX, tmCheckWord, MAXWORDLEN);
    DDX_Text(pDX, EF_NEWWORD, tmNewWord);
    DDV_MaxChars(pDX, tmNewWord, MAXWORDLEN);
    //}}AFX_DATA_MAP
}



BEGIN_MESSAGE_MAP(CWordDlg, CDialog)
    //{{AFX_MSG_MAP(CWordDlg)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()



void CWordDlg::OnOK() {

    int  ilRc;
    char szlString[MAXWORDLEN + 1] = "";


    UpdateData(TRUE);

    ilRc = SpellLoadDictionary();
    if(!ilRc) ilRc = SpellCheckWord(this->GetSafeHwnd(),
                                    (LPCSTR)tmCheckWord,
                                    (LPSTR)szlString);

    tmNewWord = szlString;

    UpdateData(FALSE);

    SpellCheckError(this->GetSafeHwnd(), ilRc);

    SpellUnloadDictionary();
}
